package conversions;

public interface Quantity {
	
	public static final int DEFAULT_TYPE = -1;
	public static final int SECTION_TYPE = 0;
	public static final int GLOBAL_GEOMETRY_TYPE = 1;
	public static final int MATERIAL_TYPE = 2;
	public static final int FASTENER_TYPE = 3;
	public static final int INTERMEDIATE_RESULTS_TYPE = 4;
	public static final int MARGIN_OF_SAFTEY_TYPE = 5;
	
    // Human readable string for a report.
	public String toString();
	
	public double getValue();
	
	public void setValue(double d);
	
	public int getType();
	
	//..
	public void convertToMetric();
	public void convertToEnglish();
	
	// non-space delimited string
	public String getUnits();
	
	// false -> english, true -> metric
	// defaults for all quants are english.
	public boolean isMetric();
	
	// self-test.
	public void test();
}